# Industry Connect Academy (ICA) Enrollment System

## Overview
A comprehensive online enrollment system for Industry Connect Academy (ICA) - a Ghanaian industrial training institution offering face-to-face, on-site courses with online registration and flexible payment options.

## Features Implemented

### 1. **Ghanaian-Localized Home Page**
- Ghana flag colors (Red, Gold, Green) integrated throughout the design
- Prominent ICA banner on the Development theme home page
- Mobile-responsive design optimized for Ghanaian users

### 2. **21 Training Programs Across 5 Categories**

#### Project Management
- Microsoft Project Training Program (GHS 1,500)

#### Height Works & Access Operations
- Work at Height Training (GHS 2,000)
- Scaffold Erectors Training (GHS 2,000)
- Scaffold Inspectors Training (GHS 2,000)
- Special Bundle: Any 2 Programs (GHS 3,500 - Save GHS 500)

#### Corrosion Protection & Surface Coating
- Industrial Coating (GHS 6,000)
- Abrasive Blasting (GHS 4,500)
- Special Bundle: Any 2 Programs (GHS 9,000 - Save GHS 1,500)

#### Non-Destructive Testing (NDT) - ASNT Level II
- Visual Testing (VT) (GHS 5,000)
- Dye Penetrant Testing (DPI) (GHS 5,000)
- Magnetic Particle Testing (MPI) (GHS 5,000)
- Ultrasonic Testing (UT) (GHS 5,000)
- Special Bundle: Any 3 Methods (GHS 12,500 - Save GHS 2,500)

#### Occupational Health, Safety & Environment (HSE)
- OH&S and the Law for Supervisors
- Laboratory Safety - International
- Warehouse Safety
- Contractor Safety
- Safety Audits
- Transportation of Dangerous Goods by Road
- Transportation of Dangerous Goods by Sea
- Transportation of Dangerous Goods by Air

### 3. **Expression of Interest (EOI) Enrollment Form**
Comprehensive form capturing:
- **Personal Information**: Surname, First Name, Email, Mobile, Age, Address, City
- **Educational Level**: SHS/TVET, Diploma/Degree, Masters, Other
- **Program Selection**: Multiple programs can be selected within same category
- **Work Experience**: Previous experience indicator and detailed work history
- **Enrollment Fee**: GHS 100.00

### 4. **Flexible Payment Options**

#### A. Mobile Money via Paystack
- Integrated Paystack payment gateway
- Supports MTN Mobile Money, Vodafone Cash, AirtelTigo Money
- Real-time payment verification
- Automatic enrollment confirmation upon successful payment

#### B. Bank Transfer
- Upload bank transaction receipt (JPG, PNG, PDF up to 5MB)
- Manual verification by admin
- Bank details displayed on form

#### C. Direct Mobile Money
- Upload mobile money transaction screenshot
- Manual verification by admin

### 5. **Admin Management Panel**

#### Enrollment Management (`/admin/ica/enrollments`)
- View all enrollments with filtering by payment and enrollment status
- Detailed enrollment view with applicant information
- Payment verification workflow:
  - View uploaded bank receipts/screenshots
  - Approve or reject payments with admin notes
  - Automatic timestamp and admin tracking
- Enrollment approval workflow:
  - Approve enrollments (only after payment confirmation)
  - Reject enrollments with reason
  - Admin notes for internal tracking

#### Program Management (`/admin/ica/programs`)
- Create, edit, and delete training programs
- Manage program details: category, name, code, price, description
- Set program requirements, benefits, and certification details
- Toggle program active/inactive status

### 6. **Success Confirmation Page**
- Professional confirmation page with enrollment details
- Display selected programs and total fees
- Payment status indicator
- Next steps information
- Printable confirmation
- Email notification promise

## Database Structure

### Tables Created

#### `ica_enrollments`
- Personal information (name, email, mobile, age, address, city)
- Educational level
- Programs of interest (JSON array)
- Work experience details
- Payment information (method, reference, receipt path)
- Payment status (pending, paid, rejected)
- Enrollment status (pending, approved, rejected)
- Admin notes and verification tracking
- Timestamps

#### `ica_programs`
- Category
- Program name and unique code
- Price
- Description, requirements, benefits, certification
- Duration and location
- Active status
- Timestamps

## Routes

### Public Routes
- `GET /ica/enrollment` - Enrollment form
- `POST /ica/enrollment` - Submit enrollment
- `GET /ica/enrollment/success/{id}` - Success page
- `GET /ica/payment/paystack/{enrollment_id}` - Paystack payment page
- `GET /ica/payment/verify` - Verify Paystack payment

### Admin Routes (requires authentication)
- `GET /admin/ica/enrollments` - List enrollments
- `GET /admin/ica/enrollment/{id}` - View enrollment details
- `POST /admin/ica/enrollment/{id}/approve-payment` - Approve payment
- `POST /admin/ica/enrollment/{id}/reject-payment` - Reject payment
- `POST /admin/ica/enrollment/{id}/approve` - Approve enrollment
- `POST /admin/ica/enrollment/{id}/reject` - Reject enrollment
- `GET /admin/ica/programs` - List programs
- `GET /admin/ica/programs/create` - Create program form
- `POST /admin/ica/programs` - Store program
- `GET /admin/ica/programs/{id}/edit` - Edit program form
- `PUT /admin/ica/programs/{id}` - Update program
- `DELETE /admin/ica/programs/{id}` - Delete program

## Files Created/Modified

### New Files
1. **Migrations**
   - `database/migrations/2026_02_22_000001_create_ica_enrollments_table.php`
   - `database/migrations/2026_02_22_000002_create_ica_programs_table.php`

2. **Models**
   - `app/Models/IcaEnrollment.php`
   - `app/Models/IcaProgram.php`

3. **Controllers**
   - `app/Http/Controllers/IcaEnrollmentController.php`
   - `app/Http/Controllers/admin/IcaAdminController.php`

4. **Views**
   - `resources/views/frontend/default/ica/enrollment.blade.php`
   - `resources/views/frontend/default/ica/paystack_payment.blade.php`
   - `resources/views/frontend/default/ica/success.blade.php`
   - `resources/views/admin/ica/enrollments/index.blade.php`
   - `resources/views/admin/ica/enrollments/show.blade.php`

5. **Seeders**
   - `database/seeders/IcaProgramSeeder.php`

6. **Routes**
   - `routes/ica.php`

### Modified Files
- `routes/web.php` - Added ICA routes inclusion
- `resources/views/components/home_permanent_templates/development.blade.php` - Added ICA banner

## Setup Instructions

### 1. Database Migration
```bash
php artisan migrate --path=/database/migrations/2026_02_22_000001_create_ica_enrollments_table.php
php artisan migrate --path=/database/migrations/2026_02_22_000002_create_ica_programs_table.php
```

### 2. Seed Programs
```bash
php artisan db:seed --class=IcaProgramSeeder
```

### 3. Configure Paystack
1. Go to Admin Panel → Settings → Payment Settings
2. Enable Paystack payment gateway
3. Add your Paystack public and secret keys (test or live)
4. Set test mode on/off as needed

### 4. Configure Storage
Ensure the storage link is created for receipt uploads:
```bash
php artisan storage:link
```

### 5. Set Permissions
```bash
chmod -R 775 storage/app/public
```

## Usage Workflow

### Student Enrollment Flow
1. Visit home page at `http://127.0.0.1:8000/`
2. Click "Submit Expression of Interest" button in ICA banner
3. Fill out enrollment form with personal details
4. Select one or multiple training programs
5. Provide work experience information
6. Choose payment method:
   - **Paystack**: Redirected to secure payment page
   - **Bank Transfer/Mobile Money**: Upload receipt
7. Submit form
8. Receive confirmation page with enrollment ID
9. Wait for email with formal application letter

### Admin Management Flow
1. Login to admin panel
2. Navigate to ICA Enrollments section
3. View pending enrollments
4. Click on enrollment to view details
5. For bank transfer/mobile money:
   - View uploaded receipt
   - Approve or reject payment
6. For approved payments:
   - Approve enrollment to finalize
7. Send formal application letter to student

## Payment Integration Details

### Paystack Configuration
- Currency: GHS (Ghana Cedis)
- Supported methods: Mobile Money (MTN, Vodafone, AirtelTigo)
- Real-time verification using Paystack API
- Secure payment reference generation

### Manual Payment Verification
- Receipts stored in `storage/app/public/ica_receipts/`
- Admin can view receipts directly from enrollment details
- Approval triggers payment_verified_at timestamp
- Admin ID tracked for audit purposes

## Security Features
- CSRF protection on all forms
- File upload validation (type and size)
- Payment verification before enrollment approval
- Admin authentication required for management
- Secure file storage with Laravel storage system

## Customization Options

### Bank Details
Update bank information in enrollment form:
`resources/views/frontend/default/ica/enrollment.blade.php` (lines ~330-335)

### Contact Information
Update contact details in success page:
`resources/views/frontend/default/ica/success.blade.php` (last section)

### Program Pricing
Modify prices in:
`database/seeders/IcaProgramSeeder.php`

Then re-seed:
```bash
php artisan db:seed --class=IcaProgramSeeder --force
```

## Future Enhancements
- Email notifications for enrollment confirmation
- SMS notifications via Ghana SMS gateway
- Automated application letter generation
- Student dashboard for tracking enrollment status
- Certificate generation upon course completion
- Integration with Ghana Revenue Authority for receipts
- Multi-language support (English, Twi, Ga)

## Support
For technical support or customization requests, contact the development team.

## License
Proprietary - Industry Connect Academy (ICA)

---
**Version**: 1.0  
**Last Updated**: February 22, 2026  
**Developer**: Custom Development Team
