<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('ica_programs', function (Blueprint $table) {
            $table->id();
            $table->string('category');
            $table->string('program_name');
            $table->string('program_code')->unique();
            $table->decimal('price', 10, 2);
            $table->text('description')->nullable();
            $table->text('requirements')->nullable();
            $table->text('benefits')->nullable();
            $table->text('certification')->nullable();
            $table->boolean('is_active')->default(true);
            $table->integer('duration_weeks')->nullable();
            $table->string('location')->default('On-site');
            $table->timestamps();
            
            $table->index('category');
            $table->index('is_active');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ica_programs');
    }
};
