@extends('layouts.admin')
@push('title', 'ICA Enrollments')
@section('content')

<div class="row">
    <div class="col-12">
        <div class="page-title-box d-flex align-items-center justify-content-between">
            <h4 class="mb-0">ICA Course Enrollments</h4>
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                    <li class="breadcrumb-item active">ICA Enrollments</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-12">
                        <form method="GET" action="{{ route('admin.ica.enrollments') }}" class="row g-3">
                            <div class="col-md-3">
                                <label class="form-label">Payment Status</label>
                                <select name="payment_status" class="form-select">
                                    <option value="">All</option>
                                    <option value="pending" {{ request('payment_status') == 'pending' ? 'selected' : '' }}>Pending</option>
                                    <option value="paid" {{ request('payment_status') == 'paid' ? 'selected' : '' }}>Paid</option>
                                    <option value="rejected" {{ request('payment_status') == 'rejected' ? 'selected' : '' }}>Rejected</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Enrollment Status</label>
                                <select name="enrollment_status" class="form-select">
                                    <option value="">All</option>
                                    <option value="pending" {{ request('enrollment_status') == 'pending' ? 'selected' : '' }}>Pending</option>
                                    <option value="approved" {{ request('enrollment_status') == 'approved' ? 'selected' : '' }}>Approved</option>
                                    <option value="rejected" {{ request('enrollment_status') == 'rejected' ? 'selected' : '' }}>Rejected</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">&nbsp;</label>
                                <button type="submit" class="btn btn-primary w-100">Filter</button>
                            </div>
                        </form>
                    </div>
                </div>

                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                <div class="table-responsive">
                    <table class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Mobile</th>
                                <th>Programs</th>
                                <th>Payment Status</th>
                                <th>Enrollment Status</th>
                                <th>Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($enrollments as $enrollment)
                            <tr>
                                <td>ICA-{{ str_pad($enrollment->id, 6, '0', STR_PAD_LEFT) }}</td>
                                <td>{{ $enrollment->first_name }} {{ $enrollment->surname }}</td>
                                <td>{{ $enrollment->email }}</td>
                                <td>{{ $enrollment->mobile }}</td>
                                <td>
                                    <span class="badge bg-info">{{ count($enrollment->programs_of_interest) }} programs</span>
                                </td>
                                <td>
                                    @if($enrollment->payment_status == 'paid')
                                        <span class="badge bg-success">Paid</span>
                                    @elseif($enrollment->payment_status == 'rejected')
                                        <span class="badge bg-danger">Rejected</span>
                                    @else
                                        <span class="badge bg-warning">Pending</span>
                                    @endif
                                </td>
                                <td>
                                    @if($enrollment->enrollment_status == 'approved')
                                        <span class="badge bg-success">Approved</span>
                                    @elseif($enrollment->enrollment_status == 'rejected')
                                        <span class="badge bg-danger">Rejected</span>
                                    @else
                                        <span class="badge bg-secondary">Pending</span>
                                    @endif
                                </td>
                                <td>{{ $enrollment->created_at->format('d M Y') }}</td>
                                <td>
                                    <a href="{{ route('admin.ica.enrollment.show', $enrollment->id) }}" class="btn btn-sm btn-primary">
                                        <i class="fas fa-eye"></i> View
                                    </a>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="9" class="text-center">No enrollments found</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <div class="mt-3">
                    {{ $enrollments->links() }}
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
