@extends('layouts.admin')
@push('title', 'ICA Training Programs')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex align-items-center justify-content-between mb-4">
            <h4 class="fw-bold mb-0">
                <i class="fi-rr-graduation-cap me-2"></i>
                ICA Training Programs
            </h4>
            <a href="{{ route('admin.ica.programs') }}" class="btn ol-btn-primary">
                <i class="fi-rr-settings me-2"></i>Manage Programs
            </a>
        </div>
    </div>
</div>

<!-- Stats Cards -->
<div class="row g-3 mb-4">
    <div class="col-xl-3 col-lg-6 col-md-6">
        <div class="card border-0" style="background: linear-gradient(135deg, #11273f 0%, #1a3a5f 100%);">
            <div class="card-body p-4">
                <div class="d-flex align-items-center justify-content-between">
                    <div>
                        <p class="text-white-50 mb-2 fw-500">Total Programs</p>
                        <h2 class="text-white fw-bold mb-0">{{ $total_programs }}</h2>
                    </div>
                    <div class="icon-bg-primary rounded-3 p-3">
                        <i class="fi-rr-graduation-cap fs-3"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-lg-6 col-md-6">
        <div class="card border-0" style="background: linear-gradient(135deg, #f2862d 0%, #ff9f4d 100%);">
            <div class="card-body p-4">
                <div class="d-flex align-items-center justify-content-between">
                    <div>
                        <p class="text-white-50 mb-2 fw-500">Categories</p>
                        <h2 class="text-white fw-bold mb-0">{{ $programsByCategory->count() }}</h2>
                    </div>
                    <div class="icon-bg-secondary rounded-3 p-3">
                        <i class="fi-rr-apps fs-3"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-lg-6 col-md-6">
        <div class="card border-0 bg-success">
            <div class="card-body p-4">
                <div class="d-flex align-items-center justify-content-between">
                    <div>
                        <p class="text-white-50 mb-2 fw-500">Active Programs</p>
                        <h2 class="text-white fw-bold mb-0">{{ $programs->where('is_active', 1)->count() }}</h2>
                    </div>
                    <div class="bg-white bg-opacity-25 rounded-3 p-3">
                        <i class="fi-rr-check-circle fs-3 text-white"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-lg-6 col-md-6">
        <div class="card border-0 bg-info">
            <div class="card-body p-4">
                <div class="d-flex align-items-center justify-content-between">
                    <div>
                        <p class="text-white-50 mb-2 fw-500">Total Enrollments</p>
                        <h2 class="text-white fw-bold mb-0">{{ \App\Models\IcaEnrollment::count() }}</h2>
                    </div>
                    <div class="bg-white bg-opacity-25 rounded-3 p-3">
                        <i class="fi-rr-users fs-3 text-white"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Programs by Category -->
@foreach($programsByCategory as $category => $categoryPrograms)
<div class="card mb-4">
    <div class="card-header bg-white border-bottom">
        <div class="d-flex align-items-center justify-content-between">
            <div>
                <h5 class="mb-1 fw-bold text-navy">
                    <i class="fi-rr-folder-open me-2 text-primary"></i>
                    {{ $category }}
                </h5>
                <p class="mb-0 text-muted small">
                    <i class="fi-rr-check-circle text-success me-1"></i>
                    {{ $categoryPrograms->count() }} Programs Available
                </p>
            </div>
            <span class="badge bg-primary">{{ $categoryPrograms->count() }}</span>
        </div>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="bg-light">
                    <tr>
                        <th class="ps-4" width="5%">#</th>
                        <th width="8%">Image</th>
                        <th width="30%">Program Name</th>
                        <th width="15%">Location</th>
                        <th width="10%">Duration</th>
                        <th width="12%">Price</th>
                        <th width="10%">Status</th>
                        <th width="10%" class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($categoryPrograms as $index => $program)
                    <tr>
                        <td class="ps-4">{{ $index + 1 }}</td>
                        <td>
                            @if($program->thumbnail && file_exists(public_path('uploads/program_thumbnails/' . $program->thumbnail)))
                                <img src="{{ asset('uploads/program_thumbnails/' . $program->thumbnail) }}" 
                                     alt="{{ $program->program_name }}" 
                                     class="rounded" 
                                     style="width: 60px; height: 60px; object-fit: cover;">
                            @else
                                <div class="bg-light rounded d-flex align-items-center justify-content-center" 
                                     style="width: 60px; height: 60px;">
                                    <i class="fi-rr-graduation-cap fs-4 text-muted"></i>
                                </div>
                            @endif
                        </td>
                        <td>
                            <div class="fw-600 text-navy">{{ $program->program_name }}</div>
                            @if($program->description)
                                <small class="text-muted">{{ Str::limit($program->description, 60) }}</small>
                            @endif
                        </td>
                        <td>
                            <i class="fi-rr-marker me-1 text-primary"></i>
                            <span class="text-muted">{{ $program->location }}</span>
                        </td>
                        <td>
                            <i class="fi-rr-clock me-1 text-warning"></i>
                            <span class="fw-500">{{ $program->duration_weeks }} weeks</span>
                        </td>
                        <td>
                            @if($program->price > 0)
                                <span class="fw-bold text-success">GHS {{ number_format($program->price, 0) }}</span>
                            @else
                                <span class="badge bg-secondary">Contact Us</span>
                            @endif
                        </td>
                        <td>
                            @if($program->is_active)
                                <span class="badge bg-success">
                                    <i class="fi-rr-check-circle me-1"></i>Active
                                </span>
                            @else
                                <span class="badge bg-secondary">
                                    <i class="fi-rr-cross-circle me-1"></i>Inactive
                                </span>
                            @endif
                        </td>
                        <td class="text-center">
                            <div class="dropdown">
                                <button class="btn btn-sm btn-light dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                    <i class="fi-rr-menu-dots"></i>
                                </button>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    <li>
                                        <a class="dropdown-item" href="{{ route('admin.ica.programs') }}">
                                            <i class="fi-rr-eye me-2"></i>View Details
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="{{ route('admin.ica.programs') }}">
                                            <i class="fi-rr-edit me-2"></i>Edit Program
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endforeach

@if($programs->isEmpty())
<div class="card">
    <div class="card-body text-center py-5">
        <i class="fi-rr-graduation-cap fs-1 text-muted mb-3 d-block"></i>
        <h5 class="text-muted">No Programs Found</h5>
        <p class="text-muted mb-4">Get started by adding your first ICA training program</p>
        <a href="{{ route('admin.ica.programs') }}" class="btn ol-btn-primary">
            <i class="fi-rr-plus me-2"></i>Add Program
        </a>
    </div>
</div>
@endif

@endsection

@push('css')
<style>
    .icon-bg-primary {
        background: rgba(255, 255, 255, 0.2);
        color: white;
    }
    
    .icon-bg-secondary {
        background: rgba(255, 255, 255, 0.2);
        color: white;
    }
    
    .table thead th {
        font-weight: 600;
        font-size: 0.85rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        color: #11273f;
    }
    
    .table tbody tr {
        transition: all 0.2s ease;
    }
    
    .table tbody tr:hover {
        background-color: rgba(242, 134, 45, 0.05);
    }
    
    .card {
        transition: all 0.3s ease;
    }
    
    .card:hover {
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.1);
    }
</style>
@endpush
