@extends('layouts.default')
@push('title', 'Login - Industry Connect Academy')
@push('meta')@endpush
@push('css')
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
<style>
    :root {
        --ghana-red: #CE1126;
        --ghana-gold: #FCD116;
        --ghana-green: #006B3F;
    }

    * {
        font-family: 'Inter', sans-serif;
    }

    body {
        background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
        min-height: 100vh;
    }

    .ica-login-container {
        min-height: 100vh;
        display: flex;
        align-items: center;
        padding: 40px 0;
    }

    .ica-login-card {
        background: white;
        border-radius: 24px;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.1);
        overflow: hidden;
        max-width: 1100px;
        margin: 0 auto;
    }

    .ica-login-left {
        background: linear-gradient(135deg, var(--ghana-green) 0%, #00a651 100%);
        padding: 60px;
        color: white;
        position: relative;
        overflow: hidden;
    }

    .ica-login-left::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(to right, var(--ghana-red), var(--ghana-gold), var(--ghana-green));
    }

    .ica-login-left::after {
        content: '';
        position: absolute;
        bottom: -50px;
        right: -50px;
        width: 200px;
        height: 200px;
        background: rgba(255, 255, 255, 0.1);
        border-radius: 50%;
    }

    .ica-login-logo {
        height: 60px;
        margin-bottom: 30px;
        filter: brightness(0) invert(1);
    }

    .ica-login-left h2 {
        font-size: 2.5rem;
        font-weight: 800;
        margin-bottom: 20px;
        text-shadow: 2px 2px 4px rgba(0,0,0,0.2);
    }

    .ica-login-left p {
        font-size: 1.1rem;
        opacity: 0.95;
        line-height: 1.8;
        margin-bottom: 30px;
    }

    .ica-feature-list {
        list-style: none;
        padding: 0;
        margin: 30px 0;
    }

    .ica-feature-list li {
        padding: 15px 0;
        display: flex;
        align-items: center;
        gap: 15px;
        font-size: 1rem;
    }

    .ica-feature-list li i {
        width: 40px;
        height: 40px;
        background: rgba(255, 255, 255, 0.2);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.2rem;
    }

    .ica-login-right {
        padding: 60px;
    }

    .ica-login-header {
        text-align: center;
        margin-bottom: 40px;
    }

    .ica-login-header h3 {
        font-size: 2rem;
        font-weight: 800;
        color: var(--ghana-green);
        margin-bottom: 10px;
    }

    .ica-login-header p {
        color: #666;
        font-size: 1rem;
    }

    .ica-form-group {
        margin-bottom: 25px;
    }

    .ica-form-label {
        font-weight: 600;
        color: #333;
        margin-bottom: 10px;
        display: block;
        font-size: 0.95rem;
    }

    .ica-form-control {
        width: 100%;
        padding: 14px 18px;
        border: 2px solid #e0e0e0;
        border-radius: 12px;
        font-size: 1rem;
        transition: all 0.3s;
        background: #fafafa;
    }

    .ica-form-control:focus {
        outline: none;
        border-color: var(--ghana-green);
        background: white;
        box-shadow: 0 0 0 4px rgba(0, 107, 63, 0.1);
    }

    .ica-password-wrapper {
        position: relative;
    }

    .ica-password-toggle {
        position: absolute;
        right: 15px;
        top: 50%;
        transform: translateY(-50%);
        background: none;
        border: none;
        color: #666;
        cursor: pointer;
        font-size: 1.2rem;
        padding: 5px;
    }

    .ica-password-toggle:hover {
        color: var(--ghana-green);
    }

    .ica-remember-row {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 25px;
    }

    .ica-checkbox-label {
        display: flex;
        align-items: center;
        gap: 8px;
        cursor: pointer;
        font-size: 0.9rem;
        color: #666;
    }

    .ica-checkbox-label input {
        width: 18px;
        height: 18px;
        cursor: pointer;
    }

    .ica-forgot-link {
        color: var(--ghana-green);
        text-decoration: none;
        font-weight: 600;
        font-size: 0.9rem;
        transition: all 0.3s;
    }

    .ica-forgot-link:hover {
        color: var(--ghana-gold);
    }

    .ica-btn-login {
        width: 100%;
        padding: 15px;
        background: linear-gradient(135deg, var(--ghana-green), #00a651);
        color: white;
        border: none;
        border-radius: 12px;
        font-weight: 700;
        font-size: 1.1rem;
        cursor: pointer;
        transition: all 0.3s;
        box-shadow: 0 5px 20px rgba(0, 107, 63, 0.3);
    }

    .ica-btn-login:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 30px rgba(0, 107, 63, 0.4);
    }

    .ica-btn-login:active {
        transform: translateY(0);
    }

    .ica-divider {
        text-align: center;
        margin: 30px 0;
        position: relative;
    }

    .ica-divider::before {
        content: '';
        position: absolute;
        left: 0;
        right: 0;
        top: 50%;
        height: 1px;
        background: #e0e0e0;
    }

    .ica-divider span {
        background: white;
        padding: 0 15px;
        position: relative;
        color: #999;
        font-size: 0.9rem;
    }

    .ica-register-link {
        text-align: center;
        margin-top: 25px;
        font-size: 1rem;
        color: #666;
    }

    .ica-register-link a {
        color: var(--ghana-green);
        font-weight: 700;
        text-decoration: none;
        transition: all 0.3s;
    }

    .ica-register-link a:hover {
        color: var(--ghana-gold);
    }

    .ica-alert {
        padding: 15px 20px;
        border-radius: 12px;
        margin-bottom: 25px;
        display: flex;
        align-items: center;
        gap: 12px;
        font-size: 0.95rem;
    }

    .ica-alert-info {
        background: #e3f2fd;
        border-left: 4px solid #2196f3;
        color: #1565c0;
    }

    .ica-alert-warning {
        background: #fff3e0;
        border-left: 4px solid #ff9800;
        color: #e65100;
    }

    .ica-alert i {
        font-size: 1.3rem;
    }

    .ica-stats {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 20px;
        margin-top: 40px;
    }

    .ica-stat-item {
        text-align: center;
        padding: 20px;
        background: rgba(255, 255, 255, 0.1);
        border-radius: 12px;
    }

    .ica-stat-number {
        font-size: 2rem;
        font-weight: 800;
        display: block;
        margin-bottom: 5px;
    }

    .ica-stat-label {
        font-size: 0.85rem;
        opacity: 0.9;
    }

    @media (max-width: 991px) {
        .ica-login-left {
            padding: 40px;
        }
        .ica-login-right {
            padding: 40px;
        }
        .ica-login-left h2 {
            font-size: 2rem;
        }
    }

    @media (max-width: 767px) {
        .ica-login-left {
            padding: 30px;
        }
        .ica-login-right {
            padding: 30px;
        }
        .ica-stats {
            grid-template-columns: 1fr;
            gap: 15px;
        }
    }
</style>
@endpush

@section('content')
<div class="ica-login-container">
    <div class="container">
        <div class="ica-login-card">
            <div class="row g-0">
                <!-- Left Side - Branding -->
                <div class="col-lg-5 d-none d-lg-block">
                    <div class="ica-login-left">
                        <img src="{{ get_image(get_frontend_settings('light_logo')) }}" alt="ICA Logo" class="ica-login-logo">
                        
                        <h2>Welcome Back!</h2>
                        <p>Login to access your Industry Connect Academy account and continue your professional training journey.</p>
                        
                        <ul class="ica-feature-list">
                            <li>
                                <i class="fas fa-check-circle"></i>
                                <span>Access 21 Professional Programs</span>
                            </li>
                            <li>
                                <i class="fas fa-check-circle"></i>
                                <span>Track Your Enrollments</span>
                            </li>
                            <li>
                                <i class="fas fa-check-circle"></i>
                                <span>Manage Your Profile</span>
                            </li>
                            <li>
                                <i class="fas fa-check-circle"></i>
                                <span>View Payment History</span>
                            </li>
                        </ul>

                        <div class="ica-stats">
                            <div class="ica-stat-item">
                                <span class="ica-stat-number">21+</span>
                                <span class="ica-stat-label">Programs</span>
                            </div>
                            <div class="ica-stat-item">
                                <span class="ica-stat-number">500+</span>
                                <span class="ica-stat-label">Students</span>
                            </div>
                            <div class="ica-stat-item">
                                <span class="ica-stat-number">100%</span>
                                <span class="ica-stat-label">Practical</span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Right Side - Login Form -->
                <div class="col-lg-7">
                    <div class="ica-login-right">
                        <div class="ica-login-header">
                            <h3>Login to Your Account</h3>
                            <p>Enter your credentials to access your dashboard</p>
                        </div>

                        @if(request()->has('redirect') && request()->redirect == 'enrollment')
                            <div class="ica-alert ica-alert-info">
                                <i class="fas fa-info-circle"></i>
                                <span><strong>Please login to continue with ICA enrollment</strong></span>
                            </div>
                        @endif

                        @if(session('error'))
                            <div class="ica-alert ica-alert-warning">
                                <i class="fas fa-exclamation-triangle"></i>
                                <span>{{ session('error') }}</span>
                            </div>
                        @endif

                        <form action="{{ route('login') }}" method="POST" id="ica-login-form">
                            @csrf

                            <div class="ica-form-group">
                                <label for="email" class="ica-form-label">Email Address</label>
                                <input type="email" id="email" name="email" class="ica-form-control" 
                                       placeholder="your.email@example.com" required autofocus
                                       value="{{ old('email') }}">
                                @error('email')
                                    <small class="text-danger mt-1 d-block">{{ $message }}</small>
                                @enderror
                            </div>

                            <div class="ica-form-group">
                                <label for="password" class="ica-form-label">Password</label>
                                <div class="ica-password-wrapper">
                                    <input type="password" id="password" name="password" class="ica-form-control" 
                                           placeholder="Enter your password" required>
                                    <button type="button" class="ica-password-toggle" onclick="togglePassword()">
                                        <i class="fas fa-eye" id="password-icon"></i>
                                    </button>
                                </div>
                                @error('password')
                                    <small class="text-danger mt-1 d-block">{{ $message }}</small>
                                @enderror
                            </div>

                            <div class="ica-remember-row">
                                <label class="ica-checkbox-label">
                                    <input type="checkbox" name="remember" id="remember">
                                    <span>Remember me</span>
                                </label>
                                <a href="{{ route('password.request') }}" class="ica-forgot-link">
                                    Forgot Password?
                                </a>
                            </div>

                            @if(get_frontend_settings('recaptcha_status'))
                                <button type="submit" class="ica-btn-login g-recaptcha" 
                                        data-sitekey="{{ get_frontend_settings('recaptcha_sitekey') }}" 
                                        data-callback='onIcaLoginSubmit' 
                                        data-action='submit'>
                                    <i class="fas fa-sign-in-alt me-2"></i> Login to Dashboard
                                </button>
                            @else
                                <button type="submit" class="ica-btn-login">
                                    <i class="fas fa-sign-in-alt me-2"></i> Login to Dashboard
                                </button>
                            @endif
                        </form>

                        <div class="ica-divider">
                            <span>OR</span>
                        </div>

                        <div class="ica-register-link">
                            Don't have an account? 
                            <a href="{{ route('register.form') }}">Create Account</a>
                        </div>

                        @if(request()->has('redirect') && request()->redirect == 'enrollment')
                            <div class="ica-alert ica-alert-warning mt-3">
                                <i class="fas fa-user-plus"></i>
                                <span><strong>New to ICA?</strong> <a href="{{ route('register.form') }}" style="color: inherit; text-decoration: underline;">Register here</a> to create your account and enroll in our training programs.</span>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('js')
<script>
    "use strict";

    function togglePassword() {
        const passwordInput = document.getElementById('password');
        const passwordIcon = document.getElementById('password-icon');
        
        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            passwordIcon.classList.remove('fa-eye');
            passwordIcon.classList.add('fa-eye-slash');
        } else {
            passwordInput.type = 'password';
            passwordIcon.classList.remove('fa-eye-slash');
            passwordIcon.classList.add('fa-eye');
        }
    }

    function onIcaLoginSubmit(token) {
        document.getElementById("ica-login-form").submit();
    }
</script>
@endpush
