@php
    $current_route = Route::currentRouteName();
@endphp

<style>
    .elegant-header {
        background: #ffffff;
        box-shadow: 0 1px 3px rgba(0,0,0,0.08);
        position: sticky;
        top: 0;
        z-index: 1000;
        border-bottom: 1px solid #e8eaed;
    }

    .elegant-header .container {
        padding: 0 15px;
    }

    .header-content {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 18px 0;
    }

    .header-logo img {
        height: 50px;
        object-fit: contain;
    }

    .header-nav {
        display: flex;
        align-items: center;
        gap: 35px;
        margin: 0 auto;
    }

    .nav-link-elegant {
        color: #2d3748;
        font-weight: 500;
        font-size: 0.95rem;
        text-decoration: none;
        padding: 8px 0;
        position: relative;
        transition: color 0.2s;
        letter-spacing: -0.01em;
    }

    .nav-link-elegant:hover,
    .nav-link-elegant.active {
        color: #f2862d;
    }

    .nav-link-elegant::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        width: 0;
        height: 2px;
        background: #f2862d;
        transition: width 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .nav-link-elegant:hover::after,
    .nav-link-elegant.active::after {
        width: 100%;
    }

    .header-actions {
        display: flex;
        align-items: center;
        gap: 15px;
    }

    .btn-header-primary {
        background: linear-gradient(135deg, #f2862d, #ff9f4d);
        color: white;
        padding: 10px 24px;
        border-radius: 6px;
        font-weight: 600;
        font-size: 0.9rem;
        text-decoration: none;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: 0 2px 8px rgba(242, 134, 45, 0.25);
        border: none;
        letter-spacing: 0.2px;
    }

    .btn-header-primary:hover {
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(242, 134, 45, 0.35);
        color: white;
    }

    .btn-header-secondary {
        background: transparent;
        color: #11273f;
        border: 1.5px solid #e8eaed;
        padding: 9px 24px;
        border-radius: 6px;
        font-weight: 600;
        font-size: 0.9rem;
        text-decoration: none;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        letter-spacing: 0.2px;
    }

    .btn-header-secondary:hover {
        border-color: #11273f;
        background: #11273f;
        color: white;
    }

    .user-avatar-elegant {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        border: 2px solid #e8eaed;
        cursor: pointer;
        transition: all 0.2s;
    }

    .user-avatar-elegant:hover {
        border-color: #f2862d;
    }

    .mobile-toggle {
        display: none;
        background: transparent;
        border: 1.5px solid #e8eaed;
        color: #11273f;
        padding: 8px 12px;
        border-radius: 6px;
        font-size: 1.1rem;
        cursor: pointer;
        transition: all 0.2s;
    }

    .mobile-toggle:hover {
        border-color: #f2862d;
        color: #f2862d;
    }

    @media (max-width: 991px) {
        .header-nav {
            display: none;
        }
        .mobile-toggle {
            display: block;
        }
    }

    @media (max-width: 767px) {
        .btn-header-secondary {
            display: none;
        }
    }
</style>

<header class="elegant-header">
    <div class="container">
        <div class="header-content">
            <!-- Logo -->
            <div class="header-logo">
                <a href="{{ route('home') }}">
                    <img src="{{ get_image(get_frontend_settings('dark_logo')) }}" alt="Industry Connect Academy">
                </a>
            </div>
            
            <!-- Navigation -->
            <nav class="header-nav d-none d-lg-flex">
                <a href="{{ route('home') }}" class="nav-link-elegant @if($current_route == 'home') active @endif">
                    Home
                </a>
                <a href="{{ route('home') }}#programs" class="nav-link-elegant" onclick="event.preventDefault(); document.getElementById('programs')?.scrollIntoView({behavior: 'smooth'});">
                    Programs
                </a>
                <a href="{{ route('about.us') }}" class="nav-link-elegant @if($current_route == 'about.us') active @endif">
                    About
                </a>
                <a href="{{ route('contact.us') }}" class="nav-link-elegant @if($current_route == 'contact.us') active @endif">
                    Contact
                </a>
            </nav>

            <!-- Actions -->
            <div class="header-actions">
                @auth
                    <a href="{{ route('ica.enrollment') }}" class="btn-header-primary d-none d-md-inline-block">
                        Enroll Now
                    </a>
                    
                    <div class="dropdown">
                        <button class="btn p-0 border-0 bg-transparent" type="button" data-bs-toggle="dropdown">
                            <img src="{{ get_image(auth()->user()->photo) }}" alt="{{ auth()->user()->name }}" class="user-avatar-elegant">
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li class="px-3 py-2 border-bottom">
                                <div class="fw-semibold" style="font-size: 0.9rem;">{{ auth()->user()->name }}</div>
                                <small class="text-muted" style="font-size: 0.8rem;">{{ auth()->user()->email }}</small>
                            </li>
                            
                            @if(in_array(auth()->user()->role, ['admin', 'instructor']))
                                <li>
                                    <a class="dropdown-item" href="{{ route(auth()->user()->role . '.dashboard') }}">
                                        <i class="fas fa-tachometer-alt me-2"></i> Dashboard
                                    </a>
                                </li>
                                <li><hr class="dropdown-divider"></li>
                            @endif
                            
                            @if(auth()->user()->role == 'admin')
                                <li>
                                    <a class="dropdown-item" href="{{ route('admin.ica.enrollments') }}">
                                        <i class="fas fa-users me-2"></i> ICA Enrollments
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="{{ route('admin.ica.programs') }}">
                                        <i class="fas fa-book me-2"></i> ICA Programs
                                    </a>
                                </li>
                                <li><hr class="dropdown-divider"></li>
                            @endif
                            
                            @if(auth()->user()->role != 'admin')
                                <li>
                                    <a class="dropdown-item" href="{{ route('my.profile') }}">
                                        <i class="fas fa-user me-2"></i> My Profile
                                    </a>
                                </li>
                            @endif
                            
                            <li>
                                <a class="dropdown-item text-danger" href="{{ route('logout') }}">
                                    <i class="fas fa-sign-out-alt me-2"></i> Logout
                                </a>
                            </li>
                        </ul>
                    </div>
                @else
                    <a href="{{ route('register') }}" class="btn-header-primary">
                        Register
                    </a>
                    <a href="{{ route('login') }}" class="btn-header-secondary d-none d-sm-inline-block">
                        Login
                    </a>
                @endauth
                
                <button class="mobile-toggle" data-bs-toggle="offcanvas" data-bs-target="#mobileMenu">
                    <i class="fas fa-bars"></i>
                </button>
            </div>
        </div>
    </div>
</header>

<!-- Mobile Menu -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="mobileMenu">
    <div class="offcanvas-header" style="background: #11273f; color: white;">
        <h5 class="offcanvas-title fw-bold">
            <i class="fas fa-graduation-cap me-2"></i> Menu
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>
    <div class="offcanvas-body">
        @auth
            <div class="d-flex align-items-center gap-3 p-3 mb-3" style="background: #f8f9fa; border-radius: 8px;">
                <img src="{{ get_image(auth()->user()->photo) }}" alt="{{ auth()->user()->name }}" style="width: 50px; height: 50px; border-radius: 50%; border: 2px solid #f2862d;">
                <div>
                    <div class="fw-semibold">{{ auth()->user()->name }}</div>
                    <small class="text-muted">{{ auth()->user()->email }}</small>
                </div>
            </div>
        @endauth
        
        <nav class="d-flex flex-column gap-2">
            <a href="{{ route('home') }}" class="btn btn-outline-dark text-start" data-bs-dismiss="offcanvas">
                <i class="fas fa-home me-2"></i> Home
            </a>
            <a href="{{ route('home') }}#programs" class="btn btn-outline-dark text-start" data-bs-dismiss="offcanvas">
                <i class="fas fa-graduation-cap me-2"></i> Programs
            </a>
            <a href="{{ route('about.us') }}" class="btn btn-outline-dark text-start" data-bs-dismiss="offcanvas">
                <i class="fas fa-info-circle me-2"></i> About
            </a>
            <a href="{{ route('contact.us') }}" class="btn btn-outline-dark text-start" data-bs-dismiss="offcanvas">
                <i class="fas fa-envelope me-2"></i> Contact
            </a>
            
            <hr>
            
            @auth
                <a href="{{ route('ica.enrollment') }}" class="btn btn-primary text-start" data-bs-dismiss="offcanvas" style="background: linear-gradient(135deg, #f2862d, #ff9f4d); border: none;">
                    <i class="fas fa-file-alt me-2"></i> Enroll Now
                </a>
                
                @if(auth()->user()->role == 'admin')
                    <a href="{{ route('admin.ica.enrollments') }}" class="btn btn-outline-secondary text-start" data-bs-dismiss="offcanvas">
                        <i class="fas fa-users me-2"></i> ICA Enrollments
                    </a>
                    <a href="{{ route('admin.ica.programs') }}" class="btn btn-outline-secondary text-start" data-bs-dismiss="offcanvas">
                        <i class="fas fa-book me-2"></i> ICA Programs
                    </a>
                @endif
                
                <a href="{{ route('logout') }}" class="btn btn-outline-danger text-start">
                    <i class="fas fa-sign-out-alt me-2"></i> Logout
                </a>
            @else
                <a href="{{ route('register') }}" class="btn btn-primary text-start" data-bs-dismiss="offcanvas" style="background: linear-gradient(135deg, #f2862d, #ff9f4d); border: none;">
                    <i class="fas fa-user-plus me-2"></i> Register
                </a>
                <a href="{{ route('login') }}" class="btn btn-outline-dark text-start" data-bs-dismiss="offcanvas">
                    <i class="fas fa-sign-in-alt me-2"></i> Login
                </a>
            @endauth
        </nav>
    </div>
</div>
