<?php

use App\Http\Controllers\IcaEnrollmentController;
use App\Http\Controllers\admin\IcaAdminController;
use Illuminate\Support\Facades\Route;

// Public ICA Routes
Route::controller(IcaEnrollmentController::class)->group(function () {
    Route::get('ica/enrollment', 'index')->middleware('auth')->name('ica.enrollment');
    Route::post('ica/enrollment', 'store')->middleware('auth')->name('ica.enrollment.store');
    Route::get('ica/enrollment/success/{id}', 'success')->middleware('auth')->name('ica.enrollment.success');
    Route::get('ica/payment/paystack/{enrollment_id}', 'initiatePaystackPayment')->middleware('auth')->name('ica.payment.paystack');
    Route::get('ica/payment/verify', 'verifyPaystackPayment')->middleware('auth')->name('ica.payment.verify');
    
    // Scaffolding Program Page
    Route::get('ica/programs/scaffolding', 'scaffoldingProgram')->name('ica.programs.scaffolding');
});

// Admin ICA Routes
Route::middleware(['auth', 'admin'])->prefix('admin')->group(function () {
    Route::controller(IcaAdminController::class)->group(function () {
        // Enrollments
        Route::get('ica/enrollments', 'enrollments')->name('admin.ica.enrollments');
        Route::get('ica/enrollment/{id}', 'showEnrollment')->name('admin.ica.enrollment.show');
        Route::post('ica/enrollment/{id}/approve-payment', 'approvePayment')->name('admin.ica.enrollment.approve-payment');
        Route::post('ica/enrollment/{id}/reject-payment', 'rejectPayment')->name('admin.ica.enrollment.reject-payment');
        Route::post('ica/enrollment/{id}/approve', 'approveEnrollment')->name('admin.ica.enrollment.approve');
        Route::post('ica/enrollment/{id}/reject', 'rejectEnrollment')->name('admin.ica.enrollment.reject');
        
        // Programs
        Route::get('ica/programs', 'programs')->name('admin.ica.programs');
        Route::get('ica/programs/create', 'createProgram')->name('admin.ica.programs.create');
        Route::post('ica/programs', 'storeProgram')->name('admin.ica.programs.store');
        Route::get('ica/programs/{id}/edit', 'editProgram')->name('admin.ica.programs.edit');
        Route::put('ica/programs/{id}', 'updateProgram')->name('admin.ica.programs.update');
        Route::delete('ica/programs/{id}', 'deleteProgram')->name('admin.ica.programs.delete');
    });
});
